// API Configuration
module.exports = {
  // 多后端URL配置 - 用于负载均衡
  BACKEND_URLS: [
    'https://cursor-money-1.onrender.com',
    'https://cursor-money-2.onrender.com'
  ],
  
  // 单一后端地址（保持向后兼容，已废弃）
  API_BASE_URL: process.env.API_BASE_URL || 'https://cursor-money-1.onrender.com',
  
  // 原始后端地址（备用）
  LEGACY_API_BASE_URL: 'http://129.204.108.166:2486',
  
  // 是否启用负载均衡（默认开启）
  ENABLE_LOAD_BALANCER: process.env.ENABLE_LOAD_BALANCER !== 'false',
};
