#!/usr/bin/env node

/**
 * 测试修复后的机器码获取方案
 * 验证 machineIdSync({ original: true }) 是否能稳定获取硬件级机器码
 */

const { machineIdSync } = require('node-machine-id');

console.log('='.repeat(70));
console.log('🧪 测试修复后的机器码获取方案');
console.log('='.repeat(70));
console.log('');

// 系统信息
console.log('📋 系统信息:');
console.log(`  • 操作系统: ${process.platform}`);
console.log(`  • Node版本: ${process.version}`);
console.log('');

// 修复后的方案（与应用中完全一致）
function generateMachineId() {
  return machineIdSync({ original: true });
}

console.log('🔍 开始测试（连续获取5次）...');
console.log('-'.repeat(70));

const results = [];
for (let i = 1; i <= 5; i++) {
  try {
    const machineId = generateMachineId();
    results.push(machineId);
    console.log(`  第${i}次: ${machineId}`);
  } catch (error) {
    console.error(`  第${i}次失败: ${error.message}`);
    process.exit(1);
  }
}

console.log('');
console.log('='.repeat(70));
console.log('📊 测试结果');
console.log('='.repeat(70));

// 检查一致性
const uniqueIds = [...new Set(results)];

if (uniqueIds.length === 1) {
  console.log('✅ 机器码稳定性测试通过！');
  console.log('');
  console.log('📱 本机机器码:', uniqueIds[0]);
  console.log('📏 机器码长度:', uniqueIds[0].length);
  console.log('📝 机器码前8位:', uniqueIds[0].substring(0, 8), '...');
  console.log('');
  console.log('💡 说明:');
  console.log('  • 5次获取结果完全一致');
  console.log('  • 这是硬件级别的唯一标识');
  console.log('  • 系统重启或更新后机器码不会改变');
  console.log('  • 用户在同一台机器上换号不会提示"已绑定其他机器码"');
  console.log('');
  console.log('✅ 修复成功！');
} else {
  console.log('❌ 机器码不稳定！');
  console.log('');
  console.log(`  发现 ${uniqueIds.length} 个不同的机器码:`);
  uniqueIds.forEach((id, idx) => {
    console.log(`    ${idx + 1}. ${id}`);
  });
  console.log('');
  console.log('⚠️ 这不应该发生，请检查环境配置');
  process.exit(1);
}

console.log('='.repeat(70));
console.log('');

